//*********************************************************************
// [COMIDAS sample program by COMIZOA Inc., Ltd]
//
// Subject : 
//   Motion Control, Coordinated Motion - COMILX_MC_StartArc_a() or COMILX_MC_Arc_a()
// Contents: 
//     COMILX_MC_StartArc_a()Լ 뿹 ̱  Դϴ. 
//	   X Y࿡ Ͽ ȣ  ̵ մϴ. 4ܰ   
//	  ܰ踶 90 ȸϿ 4ܰ   ϸ   ׸ϴ 
//	 Դϴ.   COMILX_MC_StartArc_a() Լ Ķ͵ ǹ̸ ľϴµ 
//	  ֱ  4ܰ   ׸ Ͽ δ  Ķ͸
//	 360 Ͽ ѹ    ׸  ֽϴ.
// Remarks:
//    α׷ COMI-LX501  Դϴ. 
//*********************************************************************

#include <windows.h>
#include <stdio.h>
#include <conio.h>
#include "comidaslx.h"

// (ä) ȣ //
#define X_AXIS	0
#define Y_AXIS	1
// Axis Map    Mask //
#define X_MASK	1
#define Y_MASK	2
#define Z_MASK	4
#define U_MASK	8

#define MAP0	0

#define RADIUS	5000 // Radius of circle

void CheckDone_and_Display(HANDLE hDevice)
{
	double fXPos, fYPos;
	while(!COMILX_MC_MxDone(hDevice, MAP0)){
		fXPos = COMILX_MC_GetPosition_C(hDevice, X_AXIS);
		fYPos = COMILX_MC_GetPosition_C(hDevice, Y_AXIS);
		printf("Position (X, Y) = (%.0f, %.0f)\n", fXPos, fYPos);
	}
	fXPos = COMILX_MC_GetPosition_C(hDevice, X_AXIS);
	fYPos = COMILX_MC_GetPosition_C(hDevice, Y_AXIS);
	printf("Position (X, Y) = (%.0f, %.0f)\n", fXPos, fYPos);
}

void main()
{
	double fPosList [2];

	if(!COMILX_LoadDll())
		exit(-1); // Load Dll Failure
	
	HANDLE hDevice = COMILX_LoadDevice(COMI_LX501, 0);
	if(hDevice == INVALID_HANDLE_VALUE)
		exit(-1); // Load Device Failure
	
	COMILX_MC_Reset(hDevice);

	// Map X&Y axis to MAP0 //
	COMILX_MC_MapAxes(hDevice, MAP0, X_MASK|Y_MASK);
	COMILX_MC_SetSpeedModeMx(hDevice, MAP0, 1);// Set speed mode as Trapezoidal //
	COMILX_MC_SetSpeedMx(hDevice, MAP0, 10000, 10000);// Set speed & accel => V=10000,  Acc=10000 //
	// Arc-Motion #1 : 0 Deg -> 90 Deg	//
	printf("Press any key to start Arc-motion #1\n");
	getch();
	COMILX_MC_StartArc_a(hDevice, MAP0, RADIUS, 0, 90);
	CheckDone_and_Display(hDevice);
	// Arc-Motion #2 : 90 Deg -> 180 Deg	//
	printf("\nPress any key to start Arc-motion #2\n");
	getch();
	COMILX_MC_StartArc_a(hDevice, MAP0, 0, RADIUS, 90);
	CheckDone_and_Display(hDevice);
	// Arc-Motion #3 : 180 Deg -> 270 Deg	//
	printf("\nPress any key to start Arc-motion #3\n");
	getch();
	COMILX_MC_StartArc_a(hDevice, MAP0, -RADIUS, 0, 90);
	CheckDone_and_Display(hDevice);
	// Arc-Motion #4 : 270 Deg -> 360 Deg	//
	printf("\nPress any key to start Arc-motion #4\n");
	getch();
	COMILX_MC_StartArc_a(hDevice, MAP0, 0, -RADIUS, 90);
	CheckDone_and_Display(hDevice);
	
	COMILX_UnloadDevice(hDevice);
	COMILX_UnloadDll();
}
